% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highest_concentration_terra.R
\name{plot.concentration}
\alias{plot.concentration}
\title{Automatically create a plot for objects obtained from
\code{find_highest_concentration()}}
\usage{
\method{plot}{concentration}(
  x,
  type = c("concentration", "focal", "rasterized", "updated_focal"),
  color1 = NULL,
  max.rad = 20,
  ...
)
}
\arguments{
\item{x}{x object of class \code{concentration} obtained from
\code{highest_concentration()}}

\item{type}{is one of "concentration" (default), "rasterized", "focal",
"updated_focal". See details for more information.}

\item{color1}{color when one concentration is plotted (default is "#4B0055").}

\item{max.rad}{maximal radius for size of circles in plot (default is 20).}

\item{...}{additional arguments.}
}
\description{
Automatically create a plot for objects obtained from
\code{find_highest_concentration()}.
}
\details{
More info for type:
\enumerate{
 \item "concentration": this is..
 \item "focal": this is..
 \item "rasterized": this is..
 \item "updated_focal": this is..
}
}
\examples{
x <- find_highest_concentration(Groningen, "amount")
plot(x, "concentration")
plot(x, "rasterized")
plot(x, "focal")
plot(x, "updated_focal")

}
\author{
Martin Haringa
}
