% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MI.ev.R
\name{MI.ev}
\alias{MI.ev}
\title{Moran Coefficients of Eigenvectors}
\usage{
MI.ev(W, evals)
}
\arguments{
\item{W}{spatial connectivity matrix}

\item{evals}{vector of eigenvalues}
}
\value{
Returns a vector containing the Moran coefficients of the
eigenvectors associated with the supplied eigenvalues.
}
\description{
Calculates the Moran coefficient for each eigenvector.
}
\references{
Le Gallo, Julie and Antonio Páez (2013): Using synthetic
variables in instrumental variable estimation of spatial series models.
Environment and Planning A, 45 (9): pp. 2227 - 2242.

Tiefelsdorf, Michael and Barry Boots (1995): The Exact Distribution
of Moran's I. Environment and Planning A: Economy and Space, 27 (6):
pp. 985 - 999.
}
\seealso{
\code{\link{lmFilter}}, \code{\link{glmFilter}}, \code{\link{getEVs}},
\code{\link{MI.sf}}
}
\author{
Sebastian Juhl
}
