% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srppp-xml-culture-tree.R
\name{build_culture_tree}
\alias{build_culture_tree}
\title{Build a Culture Tree}
\usage{
build_culture_tree(culture_descriptions)
}
\arguments{
\item{culture_descriptions}{A tibble containing culture descriptions with the following columns:
\itemize{
\item \code{desc_pk}: Unique identifier for each culture node.
\item \code{de}: Culture name in German.
\item \code{fr}: Culture name in French.
\item \code{it}: Culture name in Italian.
\item \code{en}: Culture name in English.
\item \code{prt_1_pk}: Identifier of the first parent node (can be NA if no parent).
\item \code{prt_2_pk}: Identifier of the second parent node (can be NA if no second parent).
}}
}
\value{
A \link[data.tree:Node]{data.tree::Node} representing the root of the
culture hierarchy. Each node in the tree has the following attributes:
\itemize{
\item \code{name_de}: The German name of the culture (from the \code{de} column).
\item \code{name_fr}: The French name of the culture (from the \code{fr} column).
\item \code{name_it}: The Italian name of the culture (from the \code{it} column).
\item \code{culture_id}: The unique identifier of the culture
}
}
\description{
Constructs a hierarchical tree structure from a culture description table
that is created within the \link{srppp_dm} function. As each culture can
have one or two parent nodes in an srppp XML file, the nodes with
two parent nodes are duplicated. The duplicated nodes retain their
primary key as an attribute, so the information on their identity
does not get lost.
}
\details{
The function builds the culture tree in two main steps:
\enumerate{
\item Node Creation: It first creates all unique culture nodes and adds them to a lookup environment.
Each node is initialized with its German name and its \code{culture_id}.
\item Relationship Establishment: It then establishes parent-child relationships between nodes.
Any node that has a second parent culture is duplicated and the duplicate
is associated with the second parent culture
}
}
\keyword{internal}
