% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STVARconstruction.R
\name{alt_stvar}
\alias{alt_stvar}
\title{Construct a STVAR model based on results from an arbitrary estimation round of \code{fitSTVAR}}
\usage{
alt_stvar(stvar, which_largest = 1, which_round, calc_std_errors = FALSE)
}
\arguments{
\item{stvar}{object of class \code{"stvar"}}

\item{which_largest}{based on estimation round with which largest log-likelihood should the model be constructed?
An integer value in 1,...,\code{nrounds}. For example, \code{which_largest=2} would take the second largest log-likelihood
and construct the model based on the corresponding estimates.}

\item{which_round}{based on which estimation round should the model be constructed? An integer value in 1,...,\code{nrounds}.
If specified, then \code{which_largest} is ignored.}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\value{
Returns an S3 object of class \code{'stvar'} defining a smooth transition VAR model. The returned list
 contains the following components (some of which may be \code{NULL} depending on the use case):
   \item{data}{The input time series data.}
   \item{model}{A list describing the model structure.}
   \item{params}{The parameters of the model.}
   \item{std_errors}{Approximate standard errors of the parameters, if calculated.}
   \item{transition_weights}{The transition weights of the model.}
   \item{regime_cmeans}{Conditional means of the regimes, if data is provided.}
   \item{total_cmeans}{Total conditional means of the model, if data is provided.}
   \item{total_ccovs}{Total conditional covariances of the model, if data is provided.}
   \item{uncond_moments}{A list of unconditional moments including regime autocovariances, variances, and means.}
   \item{residuals_raw}{Raw residuals, if data is provided.}
   \item{residuals_std}{Standardized residuals, if data is provided.}
   \item{structural_shocks}{Recovered structural shocks, if applicable.}
   \item{loglik}{Log-likelihood of the model, if data is provided.}
   \item{IC}{The values of the information criteria (AIC, HQIC, BIC) for the model, if data is provided.}
   \item{all_estimates}{The parameter estimates from all estimation rounds, if applicable.}
   \item{all_logliks}{The log-likelihood of the estimates from all estimation rounds, if applicable.}
   \item{which_converged}{Indicators of which estimation rounds converged, if applicable.}
   \item{which_round}{Indicators of which round of optimization each estimate belongs to, if applicable.}
   \item{seeds}{The seeds used in the estimation in \code{fitSTVAR}, if applicable.}
   \item{LS_estimates}{The least squares estimates of the parameters in the form
     \eqn{(\phi_{1,0},...,\phi_{M,0},\varphi_1,...,\varphi_M,\alpha} (intercepts replaced by unconditional means
     if mean parametrization is used), if applicable.}
}
\description{
\code{alt_stvar} constructs a STVAR model based on results from an arbitrary estimation
  round of \code{fitSTVAR}
}
\details{
It's sometimes useful to examine other estimates than the one with the highest log-likelihood. This function
  is wrapper around \code{STVAR} that picks the correct estimates from an object returned by \code{fitSTVAR}.
}
\examples{
\donttest{
## These are long-running examples that take approximately 10 seconds to run.

# Estimate a Gaussian STVAR p=1, M=2 model with threshold weight function and
# the first lag of the second variable as the switching variables. Run only two
# estimation rounds and use the two-phase estimation method:
fit12 <- fitSTVAR(gdpdef, p=1, M=2, weight_function="threshold", weightfun_pars=c(2, 1),
 nrounds=2, seeds=c(1, 4), estim_method="two-phase")
fit12$loglik # Log-likelihood of the estimated model

# Print the log-likelihood obtained from each estimation round:
fit12$all_logliks

# Construct the model based on the second largest log-likelihood found in the
# estimation procedure:
fit12_alt <- alt_stvar(fit12, which_largest=2, calc_std_errors=FALSE)
fit12_alt$loglik # Log-likelihood of the alternative solution

# Construct a model based on a specific estimation round, the first round:
fit12_alt2 <- alt_stvar(fit12, which_round=1, calc_std_errors=FALSE)
fit12_alt2$loglik # Log-likelihood of the alternative solution
}
}
\references{
\itemize{
   \item Anderson H., Vahid F. 1998. Testing multiple equation systems for common nonlinear components.
     \emph{Journal of Econometrics}, \strong{84}:1, 1-36.
   \item Hubrich K., Teräsvirta. T. 2013. Thresholds and Smooth Transitions in Vector Autoregressive Models.
     \emph{CREATES Research Paper 2013-18, Aarhus University.}
   \item Lanne M., Virolainen S. 2025. A Gaussian smooth transition vector autoregressive model:
      An application to the macroeconomic effects of severe weather shocks. Unpublished working
      paper, available as arXiv:2403.14216.
   \item Kheifets I.L., Saikkonen P.J. 2020. Stationarity and ergodicity of Vector STAR models.
     \emph{Econometric Reviews}, \strong{39}:4, 407-414.
   \item Lütkepohl H., Netšunajev A. 2017. Structural vector autoregressions with smooth transition in variances.
     \emph{Journal of Economic Dynamics & Control}, \strong{84}, 43-57.
   \item Tsay R. 1998. Testing and Modeling Multivariate Threshold Models.
     \emph{Journal of the American Statistical Association}, \strong{93}:443, 1188-1202.
   \item Virolainen S. 2025. Identification by non-Gaussianity in structural threshold and
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
}
\seealso{
\code{\link{STVAR}}
}
