% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_imbalance.R
\name{panel_utilheatmap}
\alias{panel_utilheatmap}
\title{Create a heatmap of resource utilization}
\usage{
panel_utilheatmap(
  data,
  legend = data$config$utilheatmap$legend,
  base_size = data$config$base_size,
  expand_x = data$config$expand,
  x_start = data$config$limits$start,
  x_end = data$config$limits$end,
  y_start = 0,
  y_end = NA,
  step = data$config$utilheatmap$step
)
}
\arguments{
\item{data}{starvz_data with trace data}

\item{legend}{enable/disable legends}

\item{base_size}{base_size base font size}

\item{expand_x}{expand size for scale_x_continuous padding}

\item{x_start}{X-axis start value}

\item{x_end}{X-axis end value}

\item{y_start}{Y-axis start value}

\item{y_end}{Y-axis end value}

\item{step}{time step for aggregation}
}
\value{
A ggplot object
}
\description{
Similar to the other resource oriented plots but shows the utilization
per time step
}
\examples{
\donttest{
panel_utilheatmap(data = starvz_sample_lu)
}
}
