% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_functions.R
\name{retrieve_data}
\alias{retrieve_data}
\title{Retrieves a specific table from Statistics Denmark}
\usage{
retrieve_data(table_id, ..., lang = "en",
  base_url = "http://api.statbank.dk/v1/")
}
\arguments{
\item{table_id}{is the id of the table you want to call. You can get table ids
by calling the \link{retrieve_tables} function.}

\item{...}{are parameters you need to use to specify what data you want from
the API. See the data created by the \link{retrieve_metadata} function.
An * indicates ALL settings in the given parameter.}

\item{lang}{whether to return the data in english or danish.}

\item{base_url}{is the base url for the API you wish to call. Statistics Denmark
can sometimes create custom API's that you can use by changing this
parameter.}
}
\value{
a data frame
}
\description{
The function retrieves a specific table from Statistics Denmark based on a
table ID and some parameters to the API.
}
\examples{

metadata <- statsDK::retrieve_metadata("FOLK1A")
dplyr::glimpse(metadata)

# See the variables as a data frame
variables <- statsDK::get_variables(metadata)
dplyr::glimpse(variables)

# Use the param and the settings columns from the variables data to set the
# rigth values for the API call.
df_en <- statsDK::retrieve_data("PRIS111", VAREGR = "000000", ENHED = "*",
                                Tid = paste(paste0("2017M0", 1:8), collapse = ","))
dplyr::glimpse(df_en)

df_da <- statsDK::retrieve_data("PRIS111", VAREGR = "000000", ENHED = "*",
                                Tid = paste(paste0("2017M0", 1:8), collapse = ","),
                                lang = "da")
dplyr::glimpse(df_da)
}
