% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_dynamics-class.R
\name{population_dynamics}
\alias{population_dynamics}
\title{Define population dynamics.}
\usage{
population_dynamics(
  change = NULL,
  dispersal = NULL,
  modification = NULL,
  density_dependence = NULL,
  dynamics_order = c("change", "dispersal", "modification", "density_dependence")
)
}
\arguments{
\item{change}{\link[steps]{population_change_functions} to define how population
growth occurs at each timestep}

\item{dispersal}{\link[steps]{population_dispersal_functions} to define how the
population disperses at each timestep}

\item{modification}{\link[steps]{population_modification_functions} to define any
deterministic changes to the population - such as translocations or population
control - at each timestep}

\item{density_dependence}{\link[steps]{population_density_dependence_functions}
to control density dependence effects on the population at each timestep}

\item{dynamics_order}{the order in which the population dynamics should be executed
on the landscape object - default is "change" -> "dispersal" -> "modification" -> "density_dependence". 
Note, if population dynamics are reordered, all dynamics must be listed in \code{dynamics_order}.}
}
\value{
An object of class \code{population_dynamics}
}
\description{
A \code{population_dynamics} object is used to describe how populations
change in space and time.
}
\details{
A population_dynamics object is passed to \link[steps]{simulation}
and defines how populations change between timesteps. Note, some dynamics
functions can be executed at non-regular intervals (i.e. only timesteps
explicitly defined by the user). The \code{population_dynamics} function is
used to construct an object with several population dynamics functions and
their associated parameters. These functions specify how the population in
the landscape object will be modified throughout a simulation. The dynamics
can be executed in any order that is specified by the user. It is cautioned
that the order of dynamics will have implications depending on whether the
user has assumed a post-breeding or pre-breeding census in the transition
matrix. For more information on this, please refer to Kendall et al, (2019)
\emph{Ecological Applications}.
}
\examples{

# Example of setting up population dynamics to only use a population change function.

\dontrun{
ls <- landscape(population = egk_pop, suitability = NULL, carrying_capacity = NULL)

pd <- population_dynamics(change = growth(egk_mat))

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
