% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{line2points}
\alias{line2points}
\alias{line2pointsn}
\alias{line2vertices}
\title{Convert a spatial (linestring) object to points}
\usage{
line2points(l, ids = rep(1:nrow(l)))

line2pointsn(l)

line2vertices(l)
}
\arguments{
\item{l}{An \code{sf} object or a \code{SpatialLinesDataFrame} from the older \code{sp} package}

\item{ids}{Vector of ids (by default \code{1:nrow(l)})}
}
\description{
The number of points will be double the number of lines with \code{line2points}. A
closely related function, \code{line2pointsn} returns all the points that were
line vertices. The points corresponding with a given line, \code{i}, will be
\code{(2*i):((2*i)+1)}. The last function, \code{line2vertices}, returns all the points
that are vertices but not nodes. If the input \code{l} object is composed by only
1 LINESTRING with 2 POINTS, then it returns an empty \code{sf} object.
}
\examples{
l <- routes_fast_sf[2, ]
lpoints <- line2points(l)
plot(l$geometry)
plot(lpoints, add = TRUE)
# test all vertices:
plot(l$geometry)
lpoints2 <- line2pointsn(l)
plot(lpoints2$geometry, add = TRUE)

# extract only internal vertices
l_internal_vertices <- line2vertices(l)
plot(sf::st_geometry(l), reset = FALSE)
plot(l_internal_vertices, add = TRUE)
# The boundary points are missing
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_midpoint}()},
\code{\link{line_segment}()},
\code{\link{line_segment1}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_segments}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()}
}
\concept{lines}
