% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suntools.R
\docType{package}
\name{suntools-package}
\alias{suntools}
\alias{suntools-package}
\title{suntools: calculate sun position, sunrise, sunset, solar noon and twilight}
\description{
Provides a set of convenient functions for calculating sun-related information, including the sun's position (elevation and azimuth), and the times of sunrise, sunset, solar noon, and twilight for any given geographical location on Earth. These calculations are based on equations provided by the National Oceanic & Atmospheric Administration (NOAA) \url{https://gml.noaa.gov/grad/solcalc/calcdetails.html} as described in "Astronomical Algorithms" by Jean Meeus (1991, ISBN: 978-0-943396-35-4). A helpful resource for researchers and professionals working in fields such as climatology, biology, and renewable energy.
}
\details{
suntools provides functions for calculating the sun's position, sunrise, sunset,
solar noon, and crepuscular (twilight) times for any given geographical location and time on earth.

Main package functions:
\itemize{
\item \code{\link[=crepuscule]{crepuscule()}}: Calculates crepuscular (twilight) times, i.e. the time of dawn or dusk.
\item \code{\link[=sunriset]{sunriset()}}: Calculates the times of sunrise and sunset at a given location.
\item \code{\link[=solarpos]{solarpos()}}: Calculates the solar position (elevation and azimuth) at a given location and time.
\item \code{\link[=solarnoon]{solarnoon()}}: Calculates solar noon time at a given location.
}
}
\references{
This package uses algorithms provided by the National Oceanic & Atmospheric Administration (NOAA), for more information see
\itemize{
\item NOAA's \href{https://gml.noaa.gov/grad/solcalc/sunrise.html}{Sunrise/Sunset Calculator}
\item NOAA's \href{https://gml.noaa.gov/grad/solcalc/azel.html}{Solar Position Calculator}
\item Meeus, J. (1991) Astronomical Algorithms. Willmann-Bell, Inc.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/adokter/suntools/}
  \item Report bugs at \url{https://github.com/adokter/suntools/issues}
}

}
\author{
\strong{Maintainer}: Adriaan M. Dokter \email{amd427@cornell.edu} (\href{https://orcid.org/0000-0001-6573-066X}{ORCID}) [contributor]

Authors:
\itemize{
  \item Roger Bivand \email{Roger.Bivand@nhh.no} (\href{https://orcid.org/0000-0003-2392-6140}{ORCID})
  \item Sebastian Luque
}

Other contributors:
\itemize{
  \item Pieter Huybrechts \email{pieter.huybrechts@inbo.be} (\href{https://orcid.org/0000-0002-6658-6062}{ORCID}) [contributor]
  \item Greg Pelletier [contributor]
  \item Alexander Tedeschi \email{at744@cornell.edu} (\href{https://orcid.org/0000-0003-0772-6931}{ORCID}) [contributor]
}

}
\keyword{internal}
