% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survSRF.R
\name{survsrf_tune}
\alias{survsrf_tune}
\title{A repeated 3-fold CV over a hyperparameters grid}
\usage{
survsrf_tune(
  df_tune,
  predict.factors,
  repeat_tune = 1,
  fixed_time = NaN,
  tuningparams = list(),
  max_grid_size = 10,
  inner_cv = 3,
  randomseed = NaN
)
}
\arguments{
\item{df_tune}{data}

\item{predict.factors}{list of predictor names}

\item{repeat_tune}{number of repeats}

\item{fixed_time}{not used here, but for some models the time for which performance is optimized}

\item{tuningparams}{if given, list of hyperparameters, list(mtry=c(), nodedepth=c(),nodesize=c()), otherwise a wide default grid is used}

\item{max_grid_size}{number of random grid searches for model tuning}

\item{inner_cv}{number of cross-validation folds for hyperparameter tuning}

\item{randomseed}{to choose random subgroup of hyperparams}
}
\value{
output=list(cindex_ordered, bestparams)
}
\description{
A repeated 3-fold CV over a hyperparameters grid
}
