% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab}
\alias{tab}
\title{Tabulate variables}
\usage{
tab(
  ...,
  test = FALSE,
  alpha = 0.05,
  p_adjust = FALSE,
  drop_na = getOption("surveytable.drop_na"),
  max_levels = getOption("surveytable.max_levels"),
  csv = getOption("surveytable.csv")
)
}
\arguments{
\item{...}{names of variables (in quotes)}

\item{test}{perform hypothesis tests?}

\item{alpha}{significance level for tests}

\item{p_adjust}{adjust p-values for multiple comparisons?}

\item{drop_na}{drop missing values (\code{NA})? Categorical variables only.}

\item{max_levels}{a categorical variable can have at most this many levels. Used to avoid printing huge tables.}

\item{csv}{name of a CSV file}
}
\value{
A list of tables or a single table.
}
\description{
Tabulate categorical (factor), logical, or numeric variables.
}
\details{
For categorical and logical variables, presents the
estimated counts, their standard errors (SEs) and confidence
intervals (CIs), percentages, and their SEs and CIs. Checks
the presentation guidelines for counts and percentages and flags
estimates if, according to the guidelines,
they should be suppressed, footnoted, or reviewed by an analyst.

For numeric variables, presents the percentage of observations with
known values, the mean of known values, the standard error of the mean (SEM), and
the standard deviation (SD).

CIs are calculated at the 95\% confidence level. CIs for
count estimates are the log Student's t CIs, with adaptations
for complex surveys. CIs for percentage estimates are
the Korn and Graubard CIs.
}
\examples{
set_survey(namcs2019sv)
tab("AGER")
tab("MDDO", "SPECCAT", "MSA")

# Numeric variables
tab("NUMMED")

# Hypothesis testing with categorical variables
tab("AGER", test = TRUE)
}
\seealso{
Other tables: 
\code{\link{tab_cross}()},
\code{\link{tab_rate}()},
\code{\link{tab_subset_rate}()},
\code{\link{total}()},
\code{\link{total_rate}()}
}
\concept{tables}
