% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{format.SurvivalAnalysisUnivariateResult}
\alias{format.SurvivalAnalysisUnivariateResult}
\title{Formats a SurvivalAnalysisUnivariateResult for printing}
\usage{
\method{format}{SurvivalAnalysisUnivariateResult}(
  x,
  ...,
  label = NULL,
  p_precision = 3,
  hr_precision = 2,
  p_less_than_cutoff = 0.001,
  time_precision = 1,
  include_end_separator = FALSE,
  timespan_unit = c("days", "months", "years")
)
}
\arguments{
\item{x}{The result generated by \code{\link{analyse_survival}}}

\item{...}{Further arguments passed from other methods.}

\item{label}{A label describing the result}

\item{p_precision, hr_precision, time_precision}{Precision with which to print floating point values}

\item{p_less_than_cutoff}{Cut-off for small p values. Values smaller than this will be displayed like "<..."}

\item{include_end_separator}{Append "\\n---\\n"? Comes handy if printing multiple results following each other}

\item{timespan_unit}{Unit for time spans: "days", "months" or "years".}
}
\value{
A formatted string, ready for output with cat()
}
\description{
Formats a SurvivalAnalysisUnivariateResult for printing
}
