% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox.R
\name{analyse_multivariate}
\alias{analyse_multivariate}
\alias{analyze_multivariate}
\title{Multivariate analysis (Cox Regression)}
\usage{
analyse_multivariate(
  data,
  time_status,
  covariates,
  interaction_covariates = NULL,
  strata = NULL,
  covariate_name_dict = NULL,
  covariate_label_dict = NULL,
  reference_level_dict = NULL,
  sort_frame_by = vars(HR)
)

analyze_multivariate(
  data,
  time_status,
  covariates,
  interaction_covariates = NULL,
  strata = NULL,
  covariate_name_dict = NULL,
  covariate_label_dict = NULL,
  reference_level_dict = NULL,
  sort_frame_by = vars(HR)
)
}
\arguments{
\item{data}{A data frame containing the time/status information and, if used, the covariate.}

\item{time_status}{A vector of length 2 giving the time and status fields.
It is recommended to use vars() and symbolic column names or code that is tidily-evaluated on \code{data}.
You can also pass a character vector with the column names or a numeric vector with column indices.}

\item{covariates}{The covariates.
Pass symbolic columns names or code that is tidily-evaluated on \code{data}.
Column names or column indices are also possible.
In any case, factors with appropriate labels will be generated which in all printouts.
You can use \code{covariate_name_dict} and \code{covariate_label_dict} to rename these factors and their levels.}

\item{interaction_covariates}{Interactions (optional). Same format as covariates.
Covariates to include together with their interaction (*, not + in the formula)}

\item{strata}{Strata (optional). Same format as covariates.
For each strata level (if multiple fields, unique combinations of levels) a separate baseline hazard is fit.}

\item{covariate_name_dict}{A dictionary (named list or vector) of old->new covariate names}

\item{covariate_label_dict}{A dictionary (named list or vector) of old->new covariate value level labels}

\item{reference_level_dict}{For categorical variables, the Cox regression uses pseudo variables for each level
relative to a reference category, resulting in n-1 variables for n levels of a categorical covariate.
Hazard ratios will be relative to the reference level, which is defined as having hazard ratio 1.0.
Per default, the reference level is the first factor level.
You can specify a different level by passing a named vector: factor name -> value of reference level.
Note that this is independent of covariate_label_dict, i.e. specify the factor level as it is in \code{data}#'}

\item{sort_frame_by}{A vars() list of one or more symbolic column names.
The result contains a data frame of the cox regression results (\code{\link{cox_as_data_frame}}).
This frame contains the variables "Lower_CI", "HR", "Upper_CI", "Inv_Lower_CI", "Inv_HR", "Inv_Upper_CI", "p".
You can specify by which variables the frame should be sorted. Default: Hazard Ratio.}
}
\value{
An object of class "SurvivalAnalysisResult" and "SurvivalAnalysisMultivariateResult".
   You can use this result as a black box for further functions in this package,
   \code{\link[=format.SurvivalAnalysisMultivariateResult]{format}} or
   \code{\link[=print.SurvivalAnalysisMultivariateResult]{print}} it,
   retrieve information as a data frame via \code{\link{multivariate_as_data_frame}} or
   access individual pieces via \code{\link{pluck_multivariate_analysis}}
}
\description{
Performs Cox regression on right-censored data using a multiple covariates.
}
\details{
This method builds upon the \code{survival} package and returns a comprehensive result object
for survival analysis containing the coxph results.
A \code{format}/\code{print} method is provided that prints the essential statistics.
}
\examples{
library(magrittr)
library(dplyr)
survival::colon \%>\%
   analyse_multivariate(vars(time, status),
                        vars(rx, sex, age, obstruct, perfor, nodes, differ, extent)) \%>\%
   print()
}
\seealso{
\code{\link{forest_plot}}
}
