% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gui_add.R
\name{gui_add}
\alias{gui_add}
\alias{guiAdd}
\alias{gui_change}
\alias{guiChange}
\alias{gui_remove}
\alias{guiRemove}
\alias{gui_list}
\alias{guiList}
\alias{gui_widgets}
\alias{guiWidgets}
\alias{gui_widgets<-}
\alias{guiWidgets<-}
\alias{gui_ask}
\alias{guiAsk}
\alias{gui_ask<-}
\alias{guiAsk<-}
\title{Creation and management of GUI objects.}
\usage{
gui_add(gui.name = ".GUI", widgets = c("nativeGUI", "textCLI"), ask)

guiAdd(gui.name = ".GUI", widgets = c("nativeGUI", "textCLI"), ask)

gui_change(
  gui.name = ".GUI",
  widgets = c("nativeGUI", "textCLI"),
  reset = FALSE,
  ask
)

guiChange(
  gui.name = ".GUI",
  widgets = c("nativeGUI", "textCLI"),
  reset = FALSE,
  ask
)

gui_remove(gui.name)

guiRemove(gui.name)

gui_list()

guiList()

gui_widgets(gui, gui.name = ".GUI")

guiWidgets(gui, gui.name = ".GUI")

gui_widgets(x, reset = FALSE) <- value

guiWidgets(x, reset = FALSE) <- value

gui_ask(gui.or.name, ask)

guiAsk(gui.or.name, ask)

gui_ask(x) <- value

guiAsk(x) <- value
}
\arguments{
\item{gui.name}{The name of the GUI. It is also the name of the object stored
in \code{SciViews:TempEnv} where you can access it.}

\item{widgets}{The list of widgets that GUI uses, listed in a priority order.}

\item{ask}{Logical indicating if modal dialog boxes should be display
(\code{ask = TRUE}), or if those dialog boxes are by-passed, using default values
to simulate script running in non interactive mode, or to test scripts
without interruption, using only provided default values (useful for
automated tests).}

\item{reset}{Should the GUI's main parameters (widgets, ask) be reset to
default values?}

\item{gui}{A \code{gui} object. If provided, it supersedes any value provided in
\code{gui.name}.}

\item{x}{A \code{gui} object.}

\item{value}{The list of widgets to add to this GUI, in priority order, or
should we change ask to \code{TRUE}, \code{FALSE} or \code{NULL} (then, use the default
value stored in \code{getOption("gui.ask")}).}

\item{gui.or.name}{A \code{gui} object or its name.}
}
\description{
Create and manipulate \code{gui} objects to manage 'SciViews'-compatible GUIs
(Graphical User Interfaces).
}
\examples{
# A 'gui' object named .GUI is automatically created in 'SciViews:TempEnv'
gui_list()

# Create a new GUI object to manage a separate GUI in the same R session
gui_add("myGUI")
gui_list()

# Change general properties of this GUI
gui_ask(myGUI) <- FALSE
# Add widgets to this GUI (you must provide methods for them)
# see the svDialogs package for examples
gui_widgets(myGUI) <- "tcltkWidgets"
gui_widgets(myGUI) # Added to existing ones if reset is FALSE

# Remove this new GUI
gui_remove("myGUI")
}
\seealso{
\link{gui}, \code{\link[=setUI]{setUI()}}, \code{\link[=dont_ask]{dont_ask()}}
}
\concept{GUI API implementation}
\keyword{misc}
