% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showSymbolicQsprayX1X2X3}
\alias{showSymbolicQsprayX1X2X3}
\title{Print a 'symbolicQspray' object}
\usage{
showSymbolicQsprayX1X2X3(a = "a", X = "X", quotientBar = " \%//\% ", ...)
}
\arguments{
\item{a}{a string, usually a letter, to denote the non-indexed variables
of the \code{ratioOfQsprays} coefficients}

\item{X}{a string, usually a letter, to denote the non-indexed variables}

\item{quotientBar}{a string for the quotient bar between the numerator and
the denominator of a \code{ratioOfQsprays} object, including surrounding
spaces, e.g. \code{"/"}}

\item{...}{arguments other than \code{showRatioOfQsprays} and
\code{showMonomial} passed to \code{\link{showSymbolicQspray}}}
}
\value{
A function which prints \code{symbolicQspray} objects.
}
\description{
Prints a \code{symbolicQspray} object.
}
\note{
This function is built by applying \code{\link{showSymbolicQspray}} to
  \code{\link[ratioOfQsprays]{showRatioOfQspraysX1X2X3}(a)} and
  \code{\link[qspray]{showMonomialX1X2X3}(X)}.
}
\examples{
set.seed(421)
Qspray <- rSymbolicQspray()
showSymbolicQsprayX1X2X3(quotientBar = " / ")(Qspray)
}
