% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--parsers.R
\name{parse_edge_list}
\alias{parse_edge_list}
\title{Convert a table with an edge list to taxmap}
\usage{
parse_edge_list(input, taxon_id, supertaxon_id, taxon_name,
  taxon_rank = NULL)
}
\arguments{
\item{input}{A table containing an edge list encoded by two columns.}

\item{taxon_id}{The name/index of the column containing the taxon IDs.}

\item{supertaxon_id}{The name/index of the column containing the taxon IDs for the supertaxon of the IDs in \code{taxon_col}.}

\item{taxon_name}{xxx}

\item{taxon_rank}{xxx}
}
\description{
Converts a table containing an edge list into a \code{\link[taxa:taxmap]{taxa::taxmap()}} object.
An "edge list" is two columns in a table, where each row defines a taxon-supertaxon relationship.
The contents of the edge list will be used as taxon IDs.
The whole table will be included as a data set in the output object.
}
\seealso{
Other parsers: \code{\link{extract_tax_data}},
  \code{\link{lookup_tax_data}},
  \code{\link{parse_tax_data}}
}
\concept{parsers}
