% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_rank_level.R
\name{taxon_rank_level}
\alias{taxon_rank_level}
\title{Taxon rank level}
\usage{
taxon_rank_level(
  level = character(),
  order = NULL,
  guess_order = TRUE,
  impute_na = FALSE
)
}
\arguments{
\item{level}{Zero or more taxonomic rank names. If a named numeric is
applied, the names are used for levels and the numeric values are used
for the order. Inputs will be transformed to a \code{character} vector.}

\item{order}{Integers that determine the relative order of taxonomic levels.
Inputs will be transformed to a \code{integer} vector. \code{NA}s can be used to
indicate that the order is not known.}

\item{guess_order}{If \code{TRUE} and no order is given, try to guess order based on rank names.}

\item{impute_na}{If \code{TRUE}, fill in NAs based on nearby values (assumed in ascending order).}
}
\value{
An \code{S3} object of class \code{taxa_taxon_rank_level}
}
\description{
Used to store taxon rank level information. This is used in \code{\link[=taxon_rank]{taxon_rank()}} objects.
}
\keyword{internal}
