% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tboot.R
\name{tboot}
\alias{tboot}
\title{Function tboot}
\usage{
tboot(nrow, weights, dataset = weights$dataset, fillMissingAug = TRUE)
}
\arguments{
\item{nrow}{number of rows in the new bootstrapped dataset.}

\item{weights}{an object of class 'tweights' output from the 'tweights' function.}

\item{dataset}{Data frame or matrix to bootstrap. Rows of the dataset must be in the 
same order as was used for the 'tweights' call. However the dataset may include
additional columns not included in the 'tweights' calll.}

\item{fillMissingAug}{fill in missing augmentation with primary weights resampling.}
}
\value{
A simulated dataset with 'nrow' rows.
}
\description{
Bootstrap \code{nrow} rows of \code{dataset} using
the given row-level weights.
}
\details{
Bootstrap simulates a dataset using the tilted weights. Details a further documented in the vignette.
}
\examples{
 target=c(Sepal.Length=5.5, Sepal.Width=2.9, Petal.Length=3.4)
 w = tweights(dataset = iris, target = target, silent = TRUE)
 simulated_data = tboot(nrow = 1000, weights = w)
}
\seealso{
\code{\link{tweights}}
}
