% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like_inference.R
\name{lrt_stat}
\alias{lrt_stat}
\title{Calculate the likelihood ratio test statistic.}
\usage{
lrt_stat(sig_null, sig_alt, p)
}
\arguments{
\item{sig_null}{A numeric. The MLE of the total variation parameter under the
null (the standard deviation version).}

\item{sig_alt}{A numeric. The MLE of the total variation parameter under the
alternative (the standard deviation version).}

\item{p}{A vector of integers. The dimension of the array.}
}
\value{
A numeric. The likelihood ratio test statistic.
}
\description{
Calulate the likelihood ratio test statistic for Kronecker structured
covariance models.
}
\details{
The LRT statistic is the exact same for all elliptically distributed
Kronecker structured covariance models (not just the normal). The
distribution of the likelihood ratio test statistic does change.
}
\references{
Gerard, D., & Hoff, P. (2016). A higher-order LQ
    decomposition for separable covariance models.
    \emph{Linear Algebra and its Applications}, 505, 57-84.
    \url{https://doi.org/10.1016/j.laa.2016.04.033}
    \url{http://arxiv.org/pdf/1410.1094v1.pdf}
}
\seealso{
\code{\link{holq}} for obtaining the MLE of the total variation
  parameter.

  \code{\link{lrt_null_dist_dim_same}} for getting the null distribution of
  the likelihood ratio test statistic.
}
\author{
David Gerard.
}
\keyword{likelihood}
