% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_patients_with_flags.R
\name{count_patients_with_flags}
\alias{count_patients_with_flags}
\alias{s_count_patients_with_flags}
\alias{a_count_patients_with_flags}
\title{Count the number of patients with particular flags}
\usage{
count_patients_with_flags(
  lyt,
  var,
  flag_variables,
  flag_labels = NULL,
  var_labels = var,
  show_labels = "hidden",
  riskdiff = FALSE,
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  table_names = paste0("tbl_flags_", var),
  .stats = "count_fraction",
  .formats = NULL,
  .indent_mods = NULL
)

s_count_patients_with_flags(
  df,
  .var,
  flag_variables,
  flag_labels = NULL,
  .N_col,
  .N_row,
  denom = c("n", "N_row", "N_col")
)

a_count_patients_with_flags(
  df,
  .var,
  flag_variables,
  flag_labels = NULL,
  .N_col,
  .N_row,
  denom = c("n", "N_row", "N_col")
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{flag_variables}{(\code{character})\cr a vector specifying the names of \code{logical} variables from analysis dataset
used for counting the number of unique identifiers.}

\item{flag_labels}{(\code{character})\cr vector of labels to use for flag variables.}

\item{var_labels}{(\code{character})\cr variable labels.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{riskdiff}{(\code{flag})\cr whether a risk difference column is present. When set to \code{TRUE}, \code{\link[=add_riskdiff]{add_riskdiff()}} must be
used as \code{split_fun} in the prior column split of the table layout, specifying which columns should be compared.
See \code{\link[=stat_propdiff_ci]{stat_propdiff_ci()}} for details on risk difference calculation.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table. Run \code{get_stats("count_patients_with_flags")}
to see available statistics for this function.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr name of the column that contains the unique identifier.}

\item{.N_col}{(\code{integer(1)})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{.N_row}{(\code{integer(1)})\cr row-wise N (row group count) for the group of observations being analyzed
(i.e. with no column-based subsetting) that is typically passed by \code{rtables}.}

\item{denom}{(\code{string})\cr choice of denominator for proportion. Options are:
\itemize{
\item \code{n}: number of values in this row and column intersection.
\item \code{N_row}: total number of values in this row across columns.
\item \code{N_col}: total number of values in this column across rows.
}}
}
\value{
\itemize{
\item \code{count_patients_with_flags()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_patients_with_flags()} to the table layout.
}

\itemize{
\item \code{s_count_patients_with_flags()} returns the count and the fraction of unique identifiers with each particular
flag as a list of statistics \code{n}, \code{count}, \code{count_fraction}, and \code{n_blq}, with one element per flag.
}

\itemize{
\item \code{a_count_patients_with_flags()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=count_patients_with_flags]{count_patients_with_flags()}} creates a layout element to calculate counts of patients for
which user-specified flags are present.

This function analyzes primary analysis variable \code{var} which indicates unique subject identifiers. Flags
variables to analyze are specified by the user via the \code{flag_variables} argument, and must either take value
\code{TRUE} (flag present) or \code{FALSE} (flag absent) for each record.

If there are multiple records with the same flag present for a patient, only one occurrence is counted.
}
\section{Functions}{
\itemize{
\item \code{count_patients_with_flags()}: Layout-creating function which can take statistics function
arguments and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_count_patients_with_flags()}: Statistics function which counts the number of patients for which
a particular flag variable is \code{TRUE}.

\item \code{a_count_patients_with_flags()}: Formatted analysis function which is used as \code{afun}
in \code{count_patients_with_flags()}.

}}
\note{
If \code{flag_labels} is not specified, variables labels will be extracted from \code{df}. If variables are not
labeled, variable names will be used instead. Alternatively, a named \code{vector} can be supplied to
\code{flag_variables} such that within each name-value pair the name corresponds to the variable name and the value is
the label to use for this variable.
}
\examples{
library(dplyr)

# Add labelled flag variables to analysis dataset.
adae <- tern_ex_adae \%>\%
  mutate(
    fl1 = TRUE \%>\% with_label("Total AEs"),
    fl2 = (TRTEMFL == "Y") \%>\%
      with_label("Total number of patients with at least one adverse event"),
    fl3 = (TRTEMFL == "Y" & AEOUT == "FATAL") \%>\%
      with_label("Total number of patients with fatal AEs"),
    fl4 = (TRTEMFL == "Y" & AEOUT == "FATAL" & AEREL == "Y") \%>\%
      with_label("Total number of patients with related fatal AEs")
  )

# `count_patients_with_flags()`

lyt2 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  count_patients_with_flags(
    "SUBJID",
    flag_variables = c("fl1", "fl2", "fl3", "fl4"),
    denom = "N_col"
  )

build_table(lyt2, adae, alt_counts_df = tern_ex_adsl)

# `s_count_patients_with_flags()`

s_count_patients_with_flags(
  adae,
  "SUBJID",
  flag_variables = c("fl1", "fl2", "fl3", "fl4"),
  denom = "N_col",
  .N_col = 1000
)

#  We need to ungroup `count_fraction` first so that the `rtables` formatting
# function `format_count_fraction()` can be applied correctly.

# `a_count_patients_with_flags()`

afun <- make_afun(a_count_patients_with_flags,
  .stats = "count_fraction",
  .ungroup_stats = "count_fraction"
)
afun(
  adae,
  .N_col = 10L,
  .N_row = 10L,
  .var = "USUBJID",
  flag_variables = c("fl1", "fl2", "fl3", "fl4")
)

}
\seealso{
\link{count_patients_with_event}
}
