% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-fun_cpt.R
\name{whomademe}
\alias{whomademe}
\title{Recover the function that created a model}
\usage{
whomademe(x, ...)
}
\arguments{
\item{x}{A \code{character} giving the name of a model. To be passed to
\code{\link[=model_name]{model_name()}}.}

\item{...}{currently ignored}
}
\value{
A \code{function}
}
\description{
Recover the function that created a model
}
\details{
Model objects (inheriting from \link{mod_cpt}) know the name of the function
that created them.
\code{\link[=whomademe]{whomademe()}} returns that function.
}
\examples{
# Get the function that made a model
f <- whomademe(fit_meanshift_norm(CET, tau = 42))
str(f)

}
\seealso{
Other model-fitting: 
\code{\link{fit_arima}()},
\code{\link{fit_lmshift}()},
\code{\link{fit_meanshift}()},
\code{\link{fit_meanvar}()},
\code{\link{fit_nhpp}()},
\code{\link{model_args}()},
\code{\link{model_name}()},
\code{\link{new_fun_cpt}()}
}
\concept{model-fitting}
