% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_azure_openai.R
\name{azure_openai}
\alias{azure_openai}
\title{Azure OpenAI Endpoint Provider Function}
\usage{
azure_openai(..., .called_from = NULL)
}
\arguments{
\item{...}{Parameters to be passed to the Azure OpenAI API specific function,
such as model configuration, input text, or API-specific options.}

\item{.called_from}{An internal argument that specifies which action (e.g.,
\code{chat}) the function is being invoked from.
This argument is automatically managed and should not be modified by the user.}
}
\value{
The result of the requested action, depending on the specific function invoked
(currently, only an updated \code{LLMMessage} object for \code{azure_openai_chat()}).
}
\description{
The \code{azure_openai()} function acts as an interface for interacting with the Azure OpenAI API
through main \code{tidyllm} verbs.
}
\details{
\code{azure_openai()} currently routes messages only to \code{azure_openai_chat()} when used with \code{chat()}.

\code{send_batch()}. It dynamically routes requests to OpenAI-specific functions
like \code{azure_openai_chat()} and \code{azure_openai_embedding()} based on the context of the call.
}
