% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.R
\name{adjust_title}
\alias{adjust_title}
\alias{adjust_x_axis_title}
\alias{adjust_y_axis_title}
\alias{adjust_caption}
\title{Adjust titles and caption}
\usage{
adjust_title(
  plot,
  title = ggplot2::waiver(),
  fontsize = NULL,
  family = NULL,
  face = NULL,
  color = "black",
  ...
)

adjust_x_axis_title(
  plot,
  title = ggplot2::waiver(),
  fontsize = NULL,
  family = NULL,
  face = NULL,
  color = "black",
  ...
)

adjust_y_axis_title(
  plot,
  title = ggplot2::waiver(),
  fontsize = NULL,
  family = NULL,
  face = NULL,
  color = "black",
  ...
)

adjust_caption(
  plot,
  caption = ggplot2::waiver(),
  fontsize = NULL,
  family = NULL,
  face = NULL,
  color = "black",
  ...
)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{title}{Plot or axes title.}

\item{fontsize}{Font size in points. Defaults to \code{7}.}

\item{family}{The typeface to use. The validity of this value will depend on
the graphics device being used for rendering the plot. See
\href{https://systemfonts.r-lib.org/articles/systemfonts.html}{the systemfonts vignette}
for guidance on the best way to access fonts installed on your computer.
The values \code{"sans"}, \code{"serif"}, and \code{"mono"} should always be valid and
will select the default typeface for the respective styles. However, what
is considered default is dependant on the graphics device and the operating
system.}

\item{face}{Font face ("plain", "italic", "bold", "bold.italic")}

\item{color}{A hex color for the stroke color. For example, \code{"#FFFFFF"} for white.}

\item{...}{Arguments passed on to \code{ggplot2::element_text()}.}

\item{caption}{Plot caption.}
}
\value{
A \code{tidyplot} object.
}
\description{
Adjust titles and caption
}
\details{
Adjust the plot title, axis titles and caption
\itemize{
\item All functions support \href{https://www.rdocumentation.org/packages/grDevices/versions/3.6.2/topics/plotmath}{plotmath expressions} to include special characters.
See examples and \href{https://jbengler.github.io/tidyplots/articles/Advanced-plotting.html#special-characters}{Advanced plotting}.
}
}
\examples{
# Plot without adjustments
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Adjust description
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_title("This is my fantastic plot title") |>
  adjust_x_axis_title("Treatment group") |>
  adjust_y_axis_title("Disease score") |>
  adjust_legend_title("Legend title") |>
  adjust_caption("Here goes the caption")

# Plotmath expressions
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_title("$H[2]*O$") |>
  adjust_x_axis_title("$H[2]*O$") |>
  adjust_y_axis_title("$H[2]*O$") |>
  adjust_legend_title("$H[2]*O$") |>
  adjust_caption("$H[2]*O$")

}
