% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loci_names.R
\name{loci_names}
\alias{loci_names}
\alias{loci_names.tbl_df}
\alias{loci_names.vctrs_bigSNP}
\title{Get the names of loci in a \code{gen_tibble}}
\usage{
loci_names(.x, .col = "genotypes", ...)

\method{loci_names}{tbl_df}(.x, .col = "genotypes", ...)

\method{loci_names}{vctrs_bigSNP}(.x, .col = "genotypes", ...)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotype} column of
a \code{\link{gen_tibble}} object),
or a \code{\link{gen_tibble}}.}

\item{.col}{the column to be used when a tibble (or grouped tibble is passed
directly to the function). This defaults to "genotypes" and can only take
that value. There is no need for the user to set it, but it is included to
resolve certain tidyselect operations.}

\item{...}{currently unused.}
}
\value{
a character vector of names
}
\description{
Extract the loci names from a  \code{gen_tibble} (or directly from its \code{genotype}
column).
}
\examples{
example_gt <- load_example_gt("gen_tbl")
example_gt \%>\% loci_names()
}
