% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average-treatment-effects-posterior.R
\name{tidy_att}
\alias{tidy_att}
\title{Get average treatment effect on treated draws from posterior}
\usage{
tidy_att(model, treatment, common_support_method, cutoff, ...)
}
\arguments{
\item{model}{A supported Bayesian model fit that can provide fits and predictions.}

\item{treatment}{A character string specifying the name of the treatment variable.}

\item{common_support_method}{Either "sd", or "chisq". Default is unspecified, and no common support calculation is done.}

\item{cutoff}{Cutoff for common support (if in use).}

\item{...}{Arguments to be passed to \code{tidybayes::fitted_draws} typically scale for \code{BART} models.}
}
\value{
A tidy data frame (tibble) with treatment effect values.
}
\description{
ATT = average Treatment Effects on Treated
Assumes treated column is either a integer column of 1's (treated) and 0's (nontreated) or logical indicating treatment if TRUE.
}
