% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cAIC.R
\name{cAIC}
\alias{cAIC}
\title{Calculate conditional AIC}
\usage{
cAIC(object)
}
\arguments{
\item{object}{Output from \code{\link[=tinyVAST]{tinyVAST()}}.}
}
\value{
cAIC value
}
\description{
Calculates the conditional Akaike Information criterion (cAIC).
}
\details{
cAIC is designed to optimize the expected out-of-sample predictive
performance for new data that share the same random effects as the in-sample
(fitted) data, e.g., spatial interpolation.  In this sense, it should be a
fast approximation to optimizing the model structure based on k-fold
cross-validation.

By contrast, \code{\link[=AIC]{AIC()}} calculates the marginal Akaike Information Criterion,
which is designed to optimize expected predictive performance for new data
that have new random effects, e.g., extrapolation, or inference about
generative parameters.

Both cAIC and EDF are calculated using Eq. 6 of Zheng, Cadigan, and Thorson
(2024).

For models that include profiled fixed effects, these profiles are turned
off.
}
\examples{
data( red_snapper )
red_snapper = droplevels(subset(red_snapper, Data_type=="Biomass_KG"))

# Define mesh
mesh = fmesher::fm_mesh_2d( red_snapper[,c('Lon','Lat')],
                           cutoff = 1 )

# define formula with a catchability covariate for gear
formula = Response_variable ~ factor(Year) + offset(log(AreaSwept_km2))

# make variable column
red_snapper$var = "logdens"
# fit using tinyVAST
fit = tinyVAST( data = red_snapper,
                formula = formula,
                sem = "logdens <-> logdens, sd_space",
                space_columns = c("Lon",'Lat'),
                spatial_graph = mesh,
                family = tweedie(link="log"),
                variable_column = "var",
                control = tinyVASTcontrol( getsd = FALSE,
                                           profile = "alpha_j" ) )

cAIC(fit) # conditional AIC
AIC(fit) # marginal AIC

}
\references{
Zheng, N., Cadigan, N., & Thorson, J. T. (2024).
A note on numerical evaluation of conditional Akaike information for
nonlinear mixed-effects models (arXiv:2411.14185). arXiv.
\doi{10.48550/arXiv.2411.14185}
}
