% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_html.R
\name{theme_html}
\alias{theme_html}
\title{HTML-specific styles and options}
\usage{
theme_html(
  x,
  engine = get_option("tinytable_html_engine", default = NULL),
  i = NULL,
  j = NULL,
  class = get_option("tinytable_html_class", default = NULL),
  css = get_option("tinytable_html_css", default = NULL),
  css_rule = get_option("tinytable_html_css_rule", default = NULL),
  portable = get_option("tinytable_html_portable"),
  tabulator_columns = get_option("tinytable_html_tabulator_columns"),
  tabulator_css_rule = get_option("tinytable_html_tabulator_css_rule"),
  tabulator_layout = get_option("tinytable_html_tabulator_layout", default =
    "fitDataTable"),
  tabulator_options = get_option("tinytable_html_tabulator_options"),
  tabulator_pagination = get_option("tinytable_html_tabulator_pagination"),
  tabulator_search = get_option("tinytable_html_tabulator_search"),
  tabulator_stylesheet = get_option("tinytable_html_tabulator_stylesheet"),
  ...
)
}
\arguments{
\item{x}{A \code{tinytable} object.}

\item{engine}{Character string specifying the HTML engine: "tinytable", "bootstrap", or "tabulator".}

\item{i}{Row indices.}

\item{j}{Column indices.}

\item{class}{String. HTML table class.}

\item{css}{Character vector. CSS style declarations.}

\item{css_rule}{String. Complete CSS rules.}

\item{portable}{Logical. Sets whether to create portable HTML output with embedded Javascript, CSS, and base64-encoded images.}

\item{tabulator_columns}{Custom column definitions.}

\item{tabulator_css_rule}{Complete CSS rules.}

\item{tabulator_layout}{Character string. Table layout algorithm for column sizing.
Default is "fitDataTable". Available options: "fitDataTable", "fitData", "fitDataFill",
"fitDataStretch", "fitColumns".}

\item{tabulator_options}{Custom Tabulator.js configuration options.}

\item{tabulator_pagination}{Logical or numeric vector. Pagination settings for large tables.
\itemize{
\item NULL (default): Preserves existing pagination settings, does not change previous configuration
\item FALSE: Explicitly disable pagination
\item TRUE: Enable pagination with automatic page sizes (10, 25, 50, 100, 250) filtered by row count
\item Numeric vector: First element is default page size, full vector provides page size options
}}

\item{tabulator_search}{Character or NULL. Search functionality position.
\itemize{
\item NULL (default): Preserves existing search settings, does not change previous configuration
\item "top": Adds search box above the table
\item "bottom": Adds search box below the table
}}

\item{tabulator_stylesheet}{Character string. CSS stylesheet theme for Tabulator.js tables.
Default is "bootstrap5". Available options: "default", "simple", "midnight", "modern",
"site", "site_dark", "bootstrap3", "bootstrap4", "bootstrap5", "semanticui", "bulma",
"materialize", or a custom HTTP URL starting with "http".}

\item{...}{Additional arguments are ignored.}
}
\description{
HTML-specific styles and options
}
