% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tipitaka-docs.R
\docType{package}
\name{tipitaka}
\alias{tipitaka}
\title{tipitaka: A package for exploring the Pali Canon in R.}
\description{
The package tipitaka provides access to the complete Pali
Canon, or Tipitaka, from R. The Tipitaka is the canonical
scripture for Therevadin Buddhists worldwide. This version
is largely taken from the Chattha Sangāyana Tipitaka
version 4.0 com;iled by the Vispassana Research Institute,
although edits have been made to conform to the numbering
used by the Pali Text Society. This package provides both
data and tools to facilitate the analysis of these ancient
Pali texts.
}
\section{Data}{

Several data sets are included:
\itemize{
  \item tipitaka_raw: the complete text of the Tipitaka
  \item tipitaka_long: the complete Tipitaka in "long" form
  \item tipitaka_wide: the complete Tipitaka in "wide" form
  \item tipitaka_names: the names of each book of the Tipitaka
  \item sutta_pitaka: the names of each volume of the Sutta Pitaka
  \item vinaya_pitaka: the names of each volume of the Vinaya Pitaka
  \item abhidhamma_pitaka: the names of each volume of the Abhidhamma Pitak
  \item sati_sutta_raw: the Mahāsatipatthāna Sutta text
  \item sati_sutta_long: the Mahāsatipatthāna Sutta in "long" form
  \item pali_alphabet: the complete pali alphabet in traditional order
  \item pali_stop_words: a set of "stop words" for Pali
  }
}

\section{Tools}{

A few useful functions are provided for working with Pali text:
\itemize{
  \item pali_lt: less-than function for Pali strings
  \item pali-gt: greater-than function for Pali strings
  \item pali-eq: equals function for Pali strings
  \item pali-sort: sorting function for vectors of pali strings
}
}

