% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{likelihood_function}
\alias{likelihood_function}
\title{Evaluate a Parameter Set with Cross-Validation}
\usage{
likelihood_function(
  dissimilarity_matrix,
  mapping_max_iter,
  relative_epsilon,
  N,
  k0,
  cooling_rate,
  c_repulsion,
  folds = 20,
  num_cores = 1
)
}
\arguments{
\item{dissimilarity_matrix}{The input dissimilarity matrix to fit.}

\item{mapping_max_iter}{The maximum number of optimization iterations.}

\item{relative_epsilon}{The convergence threshold for optimization.}

\item{N}{The number of dimensions for the embedding.}

\item{k0}{The initial spring constant.}

\item{cooling_rate}{The spring constant decay rate.}

\item{c_repulsion}{The repulsion constant.}

\item{folds}{The number of cross-validation folds.}

\item{num_cores}{The number of cores for parallel processing.}
}
\value{
A list containing the pooled \code{Holdout_MAE} and the \code{NLL}.
}
\description{
This internal function calculates the cross-validated likelihood for a given
set of parameters. It splits the data into training and validation sets across
multiple folds, fits the topolow model on each training set, and evaluates the
error on the corresponding validation set.
}
\details{
To calculate a single Negative Log-Likelihood (NLL) value per parameter set,
the function uses a "pooled errors" approach. It combines all out-of-sample
errors from every fold into a single set before calculating the NLL and the
overall Mean Absolute Error (MAE). This method respects the underlying error
distribution and correctly accounts for the total number of validation points.
}
\keyword{internal}
