% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_poisson_nll_loss}
\alias{nn_poisson_nll_loss}
\title{Poisson NLL loss}
\usage{
nn_poisson_nll_loss(
  log_input = TRUE,
  full = FALSE,
  eps = 1e-08,
  reduction = "mean"
)
}
\arguments{
\item{log_input}{(bool, optional): if \code{TRUE} the loss is computed as
\eqn{\exp(\mbox{input}) - \mbox{target}*\mbox{input}}, if \code{FALSE} the loss is
\eqn{\mbox{input} - \mbox{target}*\log(\mbox{input}+\mbox{eps})}.}

\item{full}{(bool, optional): whether to compute full loss, i. e. to add the
Stirling approximation term
\eqn{\mbox{target}*\log(\mbox{target}) - \mbox{target} + 0.5 * \log(2\pi\mbox{target})}.}

\item{eps}{(float, optional): Small value to avoid evaluation of \eqn{\log(0)} when
\code{log_input = FALSE}. Default: 1e-8}

\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed.}
}
\description{
Negative log likelihood loss with Poisson distribution of target.
The loss can be described as:
}
\details{
\deqn{
\mbox{target} \sim \mathrm{Poisson}(\mbox{input})
\mbox{loss}(\mbox{input}, \mbox{target}) = \mbox{input} - \mbox{target} * \log(\mbox{input})
+ \log(\mbox{target!})
}

The last term can be omitted or approximated with Stirling formula. The
approximation is used for target values more than 1. For targets less or
equal to 1 zeros are added to the loss.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \eqn{*} means, any number of additional
dimensions
\item Target: \eqn{(N, *)}, same shape as the input
\item Output: scalar by default. If \code{reduction} is \code{'none'}, then \eqn{(N, *)},
the same shape as the input
}
}

\examples{
if (torch_is_installed()) {
loss <- nn_poisson_nll_loss()
log_input <- torch_randn(5, 2, requires_grad = TRUE)
target <- torch_randn(5, 2)
output <- loss(log_input, target)
output$backward()
}
}
