% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colless.R
\name{colless_quad}
\alias{colless_quad}
\title{Quadratic Colless index of (im)balance.}
\usage{
colless_quad(phy, normalization = "none")
}
\arguments{
\item{phy}{phylo object or ltable}

\item{normalization}{A character string equals to "none" (default) for no
normalization or "yule"}
}
\value{
quadratic colless index
}
\description{
The Quadratic Colless index is calculated as the sum of
\eqn{(L - R)^2} over all nodes.
}
\examples{
simulated_tree <- ape::rphylo(n = 10, birth = 1, death = 0)
balanced_tree <- treestats::create_fully_balanced_tree(simulated_tree)
unbalanced_tree <- treestats::create_fully_unbalanced_tree(simulated_tree)
colless_quad(balanced_tree)
colless_quad(unbalanced_tree) # should be higher
}
\references{
Bartoszek, Krzysztof, et al. "Squaring within the Colless index
yields a better balance index." Mathematical Biosciences 331 (2021): 108503.
}
