% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.1.0.R
\name{tsesm}
\alias{tsesm}
\alias{print.tsesm}
\alias{summary.tsesm}
\title{Exponential Smoothing Forecasts}
\usage{
tsesm(
  x,
  order = c("simple", "holt", "holt-winters"),
  damped = FALSE,
  initial = c("optimal", "simple"),
  type = c("additive", "multiplicative"),
  alpha = NULL,
  beta = NULL,
  gamma = NULL,
  lambda = NULL,
  phi = NULL,
  biasadj = FALSE,
  exp.trend = FALSE,
  seasonal.period = NULL,
  train.prop = 1
)

\method{print}{tsesm}(x, ...)

\method{summary}{tsesm}(object, ...)
}
\arguments{
\item{x}{a univariate time series or a `\code{tsesm}` object.}

\item{order}{a specification of the exponential smoothing method. The available options are "\code{simple}", "\code{holt}", "\code{holt-winters}".}

\item{damped}{logical. If \code{TRUE}, a damped trend is used. Default is \code{FALSE}.}

\item{initial}{method used for selecting initial state values. Available options are `\code{optimal}` and `\code{simple}`. If `\code{optimal}`, the initial values are optimised along with the smoothing parameters using `\code{ets}`. If `\code{simple}`, the initial values are set to values obtained using simple calculations on the first few observations.}

\item{type}{specify whether the time series is `\code{additive}` or `\code{multiplicative}`.}

\item{alpha}{value of smoothing parameter for the level. If \code{NULL}, it will be estimated.}

\item{beta}{value of smoothing parameter for the trend. If \code{NULL}, it will be estimated.}

\item{gamma}{value of smoothing parameter for the seasonal component If \code{NULL}, it will be estimated.}

\item{lambda}{parameter of the Box-Cox transformation. If \code{lambda = "auto"}, a transformation is automatically selected using `\code{BoxCox.lambda}`. The transformation is ignored if \code{NULL}. Otherwise, data transformed before model is estimated.}

\item{phi}{value of damping parameter if \code{damped = TRUE}. If \code{NULL}, it will be estimated.}

\item{biasadj}{use adjusted back-transformed mean for Box-Cox transformations. If transformed data is used to produce forecasts and fitted values, a regular back transformation will result in median forecasts. If \code{biasadj == TRUE}, an adjustment will be made to produce mean forecasts and fitted values.}

\item{exp.trend}{logical. If \code{TRUE}, an exponential trend is fitted. Otherwise, the trend is (locally) linear. Default is \code{FALSE}.}

\item{seasonal.period}{number of seasons within a seasonal cycle. If \code{NULL}, the value of \code{frequency(x)} will be taken. Default is \code{NULL}.}

\item{train.prop}{a numerical value specifying the proportion of training data in the series. The value must be between 0 and 1. Default is \code{1}.}

\item{...}{other printing parameters}

\item{object}{a `\code{tsesm}` object to summarise.}
}
\value{
A list of class "\code{tsesm}" with components:

\item{coef}{a vector of smoothing parameters.}

\item{m}{number of seasons in the series, usually equivalent to the series' frequency obtained by \code{tsfreq}.}

\item{components}{values used for fitting exponential smoothing model.}

\item{states}{estimated values of all smoothing parameter for each observation.}

\item{initstate}{initial values of the smoothing parameters.}

\item{sigma2}{residual variance.}

\item{loglik}{the maximized log-likelihood, or the approximation to it used.}

\item{aic, aicc, bic}{the AIC, AICc, and BIC values corresponding to the log-likelihood. Only valid for method = "ML" fits.}

\item{x}{original series data or a `\code{tsesm}` object.}

\item{x.time}{list of time in which the series values were observed.}

\item{x.timegap}{time gap between the series and forecasted values.}

\item{x.name}{name of the time series for which forecasts was requested.}

\item{fitted}{a vector of fitted series values.}

\item{residuals}{a vector of the series residuals.}

\item{damped}{logical value indicating whether damped trend was used or not.}

\item{initial}{method used for selecting initial state values.}

\item{type}{indicator of an additive or multiplicative time series.}

\item{exp.trend}{indicator of the use of exponential trend.}

\item{lambda}{parameter value of the Box-Cox transformation.}

\item{biasadj}{indicator of the use of adjusted back-transformed mean for Box-Cox transformations.}

\item{series}{series name \code{x} in match call.}

\item{call}{the matched call.}

\item{error}{a list of prediction error estimators, including \code{$ME} for mean error, \code{$RMSE} for root mean squared error, \code{$MAE} for mean absolute error, \code{$MPE} for mean percentage error, \code{$MAPE} for mean absolute percentage error, \code{$MASE} for mean absolute scaled error, \code{$MASE.S} for seasonal mean absolute scaled error, and \code{$ACF1} for lag 1 autocorrelation.}

\item{model.test}{a list of information regarding the prediction of the testing data including `\code{x.test}` (part of `\code{x}` used for testing), `\code{fitted.test}` (predicted values of the testing data), `\code{residuals.test}` (prediction error of the testing data), and `\code{error.test}` (prediction error measurements based on the testing data). Only available if \code{train.prop} is smaller than 1.}
}
\description{
The `\code{tsesm}` function forecasts future values of a univariate time series using exponential smoothing.
}
\details{
The `\code{tsesm}` function uses the same mechanism for exponential smoothing like `\code{forecast::ses}`, `\code{forecast::holt}`, and `\code{forecast::hw}`. Instead of using three different functions, all of them are integrated in \code{tsesm}, and user can choose the method by specifying the value of the \code{order} parameter.

The option `\code{simple}` is the lowest exponential smoothing order, or the first exponential smoothing order (that's why the parameter is called `\code{order}` and not `method`). It can be used to forecast series with only level \eqn{(\ell)} component. The corresponding forecasting formula is given by:

\deqn{\tilde{x}_{t+h|t} = \ell_t = \alpha x_{t-1} + (1-\alpha)\ell_{t-1},}

where \eqn{\alpha} is the smoothing parameter for the level component, and \eqn{h} is the number of periods ahead for forecasting.

With the `\code{holt}` option, the second exponential smoothing order can be chosen. It is suitable for the forecasting of series with level \eqn{(\ell)} and trend \eqn{(b)} components.

\deqn{\ell_t = \alpha x_{t} + (1-\alpha)(\ell_{t-1} + b_{t-1})}

\deqn{b_t = \beta(\ell_{t}-\ell_{t-1}) + (1-\beta)b_{t-1}}

\deqn{\tilde{x}_{t+h|t} = \ell_{t}+hb_{t}}

where \eqn{\alpha} and \eqn{\beta} are the smoothing parameters for the level and trend components, respectively, \eqn{h} is the number of periods ahead for forecasting.

The third exponential smoothing order can be specified by the `\code{holt-winters}` option. It can be used to forecast time series with level \eqn{(\ell)}, trend \eqn{(b)}, and seasonal \eqn{(s)} components.

\deqn{\ell_t = \alpha (x_{t} - s_{t-m}) + (1-\alpha)(\ell_{t-1} + b_{t-1})}

\deqn{b_t = \beta(\ell_{t}-\ell_{t-1}) + (1-\beta)b_{t-1}}

\deqn{s_t = \gamma(x_{t}-\ell_{t-1}-b_{t-1}) + (1-\gamma)s_{t-m}}

\deqn{\tilde{x}_{t+h|t} = \ell_{t}+hb_{t}+s_{t+h-m(k+1)}}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\gamma} are the smoothing parameters for the level, trend, and seasonal components, respectively, \eqn{h} is the number of periods ahead for forecasting, \eqn{m} is the number of periods within a seasonal cycle, and \eqn{k} is the integer part of \eqn{(h-1)/m}, which ensures that the estimates of the seasonal indices used for forecasting come from the final period of the series.

If \code{train.prop} is smaller than 1, the function will only treat the training part of the series as past data. When applying `\code{tsforecast}` or `\code{predict}`, the forecast will start after the end of the training part of the original series.
}
\examples{
tsesm(airport$Travellers, order = "simple")
tsesm(airport$Travellers, order = "holt")
tsesm(airport$Travellers, order = "holt-winters")
}
\references{
Box, G. E. P., & Jenkins, G. M. (1970). Time series analysis: Forecasting and control. Holden-Day.

Hyndman, R. J., Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}

Hyndman, R. J., Athanasopoulos, G., Bergmeir, C., Caceres, G., Chhay, L., O'Hara-Wild, M., Petropoulos, F., Razbash, S., Wang, E., Yasmeen, F. (2025). \cr \emph{forecast: Forecasting functions for time series and linear models}. R package version 8.24.0, \cr \url{https://pkg.robjhyndman.com/forecast/}.

Hyndman, R. J., Khandakar, Y. (2008). Automatic time series forecasting: the forecast package for R. \emph{Journal of Statistical Software}, \strong{27}(3), 1-22.
}
\author{
Ka Yui Karl Wu
}
