% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.0.R
\name{tsexplore}
\alias{tsexplore}
\alias{plot.tsexplore}
\alias{print.tsexplore}
\title{Explore a Time Series Numerically and Graphically}
\usage{
tsexplore(
  x,
  show.plot = TRUE,
  x.name = NULL,
  mu = 0,
  adf.lag = 0,
  lag.max = 8,
  ...
)

\method{plot}{tsexplore}(
  x,
  trend = c("linear", "smooth", "none"),
  histbin = 15,
  lwidth = 0.7,
  pwidth = 0.7,
  x.col = "darkgrey",
  extra.col = "red",
  plot.incl = c("all", "line", "hist", "box", "qq", "acf", "pacf"),
  ...
)

\method{print}{tsexplore}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  stats.incl = c("all", "stats", "var", "qtls", "acf", "tests"),
  ...
)
}
\arguments{
\item{x}{a time series to be explored or a `\code{tsexplore}` object.}

\item{show.plot}{logical. If \code{TRUE}, all exploration charts will be displayed directly. Default is \code{TRUE}.}

\item{x.name}{name of the series. If omitted here, the series name found by \code{tsname()} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{mu}{test value specified under the null hypothesis of the t-test for the mean location. Default is \code{0}.}

\item{adf.lag}{number of AR lags included in the ADF test. Default is \code{0}.}

\item{lag.max}{maximum lag at which to calculate the acf. Default is \code{8}. Will be automatically limited to one less than the number of observations in the series. If the series has less than 8 observations.}

\item{...}{parameter values that can affect the plots created for time series exploration.}

\item{trend}{a character string indicating whether and how the trend line should be fitted in the time series line plot. Available options are `\code{linear}`, `\code{smooth}`, `\code{none}`. Default is `\code{linear}`.}

\item{histbin}{a numeric value to specify the number of bins in the histogram. Can be omitted. Default is \code{15}.}

\item{lwidth}{line width of the series line plot. Default is \code{0.7}.}

\item{pwidth}{size of the markers in the QQ plot. Default is \code{0.7}.}

\item{x.col}{line colour of the time series line plot. Default is `\code{darkgrey}`.}

\item{extra.col}{colour of extra information in the plots. Default is `\code{red}`.}

\item{plot.incl}{time series components that should be plotted. Available options are `\code{all}` (default), `\code{line}` (line plot), `\code{hist}` (histogram), `\code{box}` (boxplot), `\code{qq}` (QQ plot), `\code{acf}` (ACF plot), and `\code{pacf}` (PACF plot). Ignored if \code{show.plot = FALSE}.}

\item{digits}{the number of significant digits.}

\item{stats.incl}{time series statistics that should be printed. Available options are `\code{all}` (default), `\code{stats}` (statistics), `\code{var}` (variability), `\code{qtls}` (quantiles), `\code{acf}` (autocorrelation), and `\code{tests}` (tests).}
}
\value{
An object of class "\code{tsexplore}" with following components:

\item{x}{original series data}

\item{x.time}{list of time in which the series values were observed.}

\item{x.timegap}{time gap between the series and forecasted values.}

\item{x.name}{name of the time series for which forecasts was requested.}

\item{stats}{a list of statistics and test results conducted on the time series}
}
\description{
The function `\code{tsexplore}` generates statistics, various tests, and graphs regarding the location, deviation, distribution of a time series.
}
\section{Details of the `\code{stats}` component}{

The following statistics and test results are stored in the component `\code{stats}` of the `\code{tsexplore}` object: 
\tabular{lcl}{\code{statistics} \tab \tab \code{n} (number of observations), \code{nvalid} (number of valid observations), \code{sum}, \code{mean}, \code{median}, \code{skewness}, \code{kurtosis}, \code{cv} (coefficient of variation) \cr
\code{variability} \tab \tab \code{variance}, \code{sd} (standard deviation), \code{range}, \code{iqr} (interquartile range) \cr
\code{quantiles} \tab \tab \code{minimum}, \code{q1} (1st quartile), \code{median}, \code{q3} (3rd quartile), \code{maximum} \cr
\code{autocorrelation} \tab \tab \code{acf} (autocorrelation function), \code{pacf} (partial autocorrelation function) - from lag 0 (ACF) or lag 1 (PACF) until \code{lag.max} \cr
\code{tests} \tab \tab \code{location} (t-test), \code{normality} (Shapiro-Wilk-test), \code{stationarity} (ADF-test), \code{independence} (Ljung-Box-test) - each test contains the test statistics (\code{statistics} and the p-value (\code{p.value})) \cr
}
}

\examples{
tsexplore(airport$Travellers, lag.max = 24, histbin = 10)
}
\references{
Hyndman, R. J., & Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}
}
\author{
Ka Yui Karl Wu
}
