% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helsinki.R
\docType{data}
\name{helsinki_2}
\alias{helsinki_2}
\title{Grayscale colors of the University of Helsinki, Finland}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on 
the \href{https://www.helsinki.fi}{UH}'s 
\href{https://static.helsinki.fi/ds/tokens/color.html}{brand guide} (HTML).
}
\usage{
helsinki_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{helsinki_2} provides the grayscale colors 
of the \href{https://www.helsinki.fi}{University of Helsinki}, Finland.
}
\details{
To be used in combination with the main brand colors of \code{\link{helsinki_1}}.

\code{helsinki_2} is based on HEX color definitions.
}
\examples{
helsinki_2
unikn::seecol(helsinki_2, col_bg = "grey90",  
              main = "Grayscale colors of the University of Helsinki, Finland") # view palette

}
\seealso{
\code{\link{helsinki_1}} for main brand colors of the University of Helsinki;
\code{\link{helsinki_3}} for departmental colors of the University of Helsinki;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Finnish university color palettes: 
\code{\link{aalto_1}},
\code{\link{aalto_2}},
\code{\link{helsinki_1}},
\code{\link{helsinki_3}}
}
\author{
\strong{unicol}, 2023-10-15.
}
\concept{Finnish university color palettes}
\keyword{datasets}
