% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oxford.R
\docType{data}
\name{oxford_shades}
\alias{oxford_shades}
\title{Shade colours of University of Oxford, England, UK}
\format{
An object of class \code{character} of length 7.
}
\source{
Colour definitions are based on the
\href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
}
\usage{
oxford_shades
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{oxford_shades} provides the seven shade colours 
of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
}
\details{
The 7 shade colours are
\code{"black"} (defined as HEX #000000),
\code{"off_black"} (defined as HEX #333333),
\code{"mid_grey"} (defined as HEX #7a736e),
\code{"dark_grey"} (defined as HEX #a6a6a6),
\code{"light_grey"} (defined as HEX #e0ded9),
\code{"light_grey"} (defined as HEX #f9f8f5), and
\code{"white"} (defined as HEX #ffffff).
}
\examples{
oxford_shades
unikn::seecol(oxford_shades, main = "Uni Oxford shade colours") # view colour palette

}
\seealso{
\code{\link{oxford_brand}} for the brand colours of University of Oxford;
\code{\link{oxford_general}} for the general colours of University of Oxford;
\code{\link{oxford_link}} for the link colours of University of Oxford;
\code{\link{oxford_blog}} for the blog colours of University of Oxford;
\code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
\code{\link{oxford_error}} for the error colours of University of Oxford;
\code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_link}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-19.
}
\concept{English university color palettes}
\keyword{datasets}
