% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{tidyverse}
\alias{tidyverse}
\alias{use_tidy_ci}
\alias{use_tidy_description}
\alias{use_tidy_versions}
\alias{use_tidy_eval}
\alias{use_tidy_contributing}
\alias{use_tidy_issue_template}
\alias{use_tidy_support}
\title{Helpers for the tidyverse}
\usage{
use_tidy_ci(browse = interactive())

use_tidy_description()

use_tidy_versions(overwrite = FALSE)

use_tidy_eval()

use_tidy_contributing()

use_tidy_issue_template()

use_tidy_support()
}
\arguments{
\item{browse}{Open a browser window to enable automatic builds for the
package.}

\item{overwrite}{By default (\code{FALSE}), only dependencies without version
specifications will be modified. Set to \code{TRUE} to modify all dependencies.}
}
\description{
These helpers follow tidyverse conventions which are generally a little
stricter than the defaults, reflecting the need for greater rigor in
commonly used packages.
}
\details{
\itemize{
\item \code{use_tidy_ci()}: sets up travis and codecov, ensuring that the package
works on all versions of R starting at 3.1.
\item \code{use_tidy_description()}: puts fields in standard order and alphabetises
dependencies.
\item \code{use_tidy_eval()}: imports a standard set of helpers to facilitate
programming with the tidy eval toolkit.
\item \code{use_tidy_versions()}: pins all dependencies to require at least
the currently installed version.
\item \code{use_tidy_contributing()}: creates tidyverse contributing guidelines from
tidy_contributing template.
\item \code{use_tidy_issue_template()}: creates a standard tidyverse issue template.
\item \code{use_tidy_support()}: creates support resources document for GitHub repo
using SUPPORT.md.
}
}
