% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redundancy.R
\name{detect_redundancy}
\alias{detect_redundancy}
\title{Detect redundant rules without removing.}
\usage{
detect_redundancy(x, ...)
}
\arguments{
\item{x}{\code{\link{validator}} object with the validation rules.}

\item{...}{not used.}
}
\description{
Detect redundancies in a rule set.
}
\note{
For removal of duplicate rules, simplify
}
\examples{
rules <- validator( rule1 = x > 1
                  , rule2 = x > 2
                  )

# rule1 is superfluous
remove_redundancy(rules)

# rule 1 is implied by rule 2
is_implied_by(rules, "rule1")

rules <- validator( rule1 = x > 2
                  , rule2 = x > 2
)

# standout: rule1 and rule2, oldest rules wins
remove_redundancy(rules)

# Note that detection signifies both rules!
detect_redundancy(rules)


}
\seealso{
Other redundancy: 
\code{\link{detect_fixed_variables}()},
\code{\link{is_implied_by}()},
\code{\link{remove_redundancy}()},
\code{\link{simplify_fixed_variables}()},
\code{\link{simplify_rules}()}
}
\concept{redundancy}
