% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{boxPlot}
\alias{boxPlot}
\title{Create a box plot visualisation from a \verb{<summarised_result>} object}
\usage{
boxPlot(
  result,
  x,
  lower = "q25",
  middle = "median",
  upper = "q75",
  ymin = "min",
  ymax = "max",
  facet = NULL,
  colour = NULL,
  style = "default",
  type = "ggplot",
  label = character()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{x}{Column or estimate name that is used as x variable.}

\item{lower}{Estimate name for the lower quantile of the box.}

\item{middle}{Estimate name for the middle line of the box.}

\item{upper}{Estimate name for the upper quantile of the box.}

\item{ymin}{Lower limit of error bars, if provided is plot using
\code{geom_errorbar}.}

\item{ymax}{Upper limit of error bars, if provided is plot using
\code{geom_errorbar}.}

\item{facet}{Variables to facet by, a formula can be provided to specify
which variables should be used as rows and which ones as columns.}

\item{colour}{Columns to use to determine the colours.}

\item{style}{A character string defining the visual theme to apply to the plot.
You can set this to NULL to apply the standard ggplot2 default style,
or provide a name for one of the package's pre-defined styles. Refer to the
\code{plotStyle()} function for all available style pre-defined themes.
For further customization, you can always modify the returned ggplot object
directly.}

\item{type}{The desired format of the output plot. See \code{plotType()} for
supported plot types.}

\item{label}{Character vector with the columns to display interactively in
\code{plotly}.}
}
\value{
A ggplot2 object.
}
\description{
Create a box plot visualisation from a \verb{<summarised_result>} object
}
\examples{
dplyr::tibble(year = "2000", q25 = 25, median = 50, q75 = 75, min = 0, max = 100) |>
  boxPlot(x = "year")

}
