% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{scatterPlot}
\alias{scatterPlot}
\title{Create a scatter plot visualisation from a \verb{<summarised_result>} object}
\usage{
scatterPlot(
  result,
  x,
  y,
  line,
  point,
  ribbon,
  ymin = NULL,
  ymax = NULL,
  facet = NULL,
  colour = NULL,
  style = "default",
  type = "ggplot",
  group = colour,
  label = character()
)
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{x}{Column or estimate name that is used as x variable.}

\item{y}{Column or estimate name that is used as y variable.}

\item{line}{Whether to plot a line using \code{geom_line}.}

\item{point}{Whether to plot points using \code{geom_point}.}

\item{ribbon}{Whether to plot a ribbon using \code{geom_ribbon}.}

\item{ymin}{Lower limit of error bars, if provided is plot using
\code{geom_errorbar}.}

\item{ymax}{Upper limit of error bars, if provided is plot using
\code{geom_errorbar}.}

\item{facet}{Variables to facet by, a formula can be provided to specify
which variables should be used as rows and which ones as columns.}

\item{colour}{Columns to use to determine the colours.}

\item{style}{A character string defining the visual theme to apply to the plot.
You can set this to NULL to apply the standard ggplot2 default style,
or provide a name for one of the package's pre-defined styles. Refer to the
\code{plotStyle()} function for all available style pre-defined themes.
For further customization, you can always modify the returned ggplot object
directly.}

\item{type}{The desired format of the output plot. See \code{plotType()} for
supported plot types.}

\item{group}{Columns to use to determine the group.}

\item{label}{Character vector with the columns to display interactively in
\code{plotly}.}
}
\value{
A plot object.
}
\description{
Create a scatter plot visualisation from a \verb{<summarised_result>} object
}
\examples{
result <- mockSummarisedResult() |>
  dplyr::filter(variable_name == "age")

scatterPlot(
  result = result,
  x = "cohort_name",
  y = "mean",
  line = TRUE,
  point = TRUE,
  ribbon = FALSE,
  facet = age_group ~ sex)

}
