% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.r
\name{header}
\alias{header}
\title{Assemble an HTTP header.}
\usage{
header(..., expose = FALSE, name = ...names(), value = ..1)
}
\arguments{
\item{...}{A single key-value pair.}

\item{expose}{Allow javascript to read this header.}

\item{name}{Explicitly set the name (key) in the key-value pair.}

\item{value}{Explicitly set the value in the key-value pair.}
}
\value{
A 'header' object that can be passed to \code{response()}.
}
\description{
See https://developer.mozilla.org/en-US/docs/Glossary/Response_header for
example response headers and their purpose.
}
\examples{

    library(webqueue)
    
    header(name = 'Location', value = '/index.html')
    
    Location <- '/index.html'
    header(Location)
    
    response(307L, header(Location = '/index.html'))
    
    # Allow javascript to access a header value
    header('x-user-id' = 100, expose = TRUE)
    
}
