% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataRequest.R
\name{clean}
\alias{clean}
\title{Generate clean data frames from cleaning scripts created in the ./clean directory}
\usage{
clean(..., csv = FALSE, rdata = FALSE, spss = FALSE, skip_prompt = FALSE)
}
\arguments{
\item{...}{Strings, specifying the measures to process, which can be a Mongo collection, REDCap instrument, or Qualtrics survey.}

\item{csv}{Optional; Boolean, if TRUE creates a .csv extract in ./tmp.}

\item{rdata}{Optional; Boolean, if TRUE creates an .rdata extract in ./tmp.}

\item{spss}{Optional; Boolean, if TRUE creates a .sav extract in ./tmp.}

\item{skip_prompt}{Logical. If TRUE, skips confirmation prompts. If FALSE (default),
prompts for confirmation unless the user has previously chosen to remember their preference.}
}
\value{
Prints the time taken for the data request process.
}
\description{
This function processes requests for clean data sequentially for specified measures.
It makes a request to the appropriate API for the named measure or measures
and runs the associated data cleaning routines. It then runs a series of
unit tests to verify that the data quality standards are met.
}
\examples{
\dontrun{
  clean("prl", csv=TRUE)
  clean("rgpts", "kamin", rdata=TRUE)
  
  # Skip confirmation prompts
  clean("prl", csv=TRUE, skip_prompt=TRUE)
}

}
\author{
Joshua Kenney \href{mailto:joshua.kenney@yale.edu}{joshua.kenney@yale.edu}
}
