% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNFfileIO.R
\name{newBNF}
\alias{newBNF}
\title{Convert grammar file into a constant function.}
\usage{
newBNF(filename, eol = "\\n")
}
\arguments{
\item{filename}{A file name.}

\item{eol}{End-of-line symbol(s). Default: \code{"\\n"}}
}
\value{
Returns a constant function which returns a BNF.
}
\description{
\code{newBNF()} reads a text file and 
             returns a constant function which returns
             the BNF as a character string.
}
\details{
The purpose of this function is to include examples
         of grammars in packages.
}
\examples{
g<-booleanGrammar()
fn<-tempfile()
writeBNF(g, fn)
g1<-newBNF(fn)
unlink(fn)
}
\seealso{
Other File I/O: 
\code{\link{readBNF}()},
\code{\link{writeBNF}()}
}
\concept{File I/O}
