% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose_data_nlmixr.R
\name{xpose_data_nlmixr2}
\alias{xpose_data_nlmixr2}
\alias{xpose_data_nlmixr}
\title{Import nlmixr2 output into xpose object}
\usage{
xpose_data_nlmixr2(
  obj = NULL,
  pred = NULL,
  wres = NULL,
  gg_theme = theme_readable(),
  xp_theme = theme_xp_default(),
  quiet,
  skip = NULL,
  ...
)

xpose_data_nlmixr(
  obj = NULL,
  pred = NULL,
  wres = NULL,
  gg_theme = theme_readable(),
  xp_theme = theme_xp_default(),
  quiet,
  skip = NULL,
  ...
)
}
\arguments{
\item{obj}{nlmixr2 fit object to be evaluated.}

\item{pred}{Name of the population prediction variable to use for
plotting. If unspecified, it will choose either "NPDE",
"CWRES", and "RES" (in that order) if the column exists in the
data.}

\item{wres}{Name of the weighted residual variable to use for
plotting. If unspecified, it will choose either "NPDE",
"CWRES", and "RES" (in that order) if the column exists in the
data.}

\item{gg_theme}{A ggplot2 theme object.}

\item{xp_theme}{An xpose theme or vector of modifications to the
xpose theme (eg. \code{c(point_color = 'red', line_linetype =
'dashed')}).}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the
console.}

\item{skip}{Character vector be used to skip the import/generation
of: 'data', 'files', 'summary' or any combination of the three.}

\item{...}{Additional arguments to be passed to the
\code{\link[readr]{read_delim}} functions.}
}
\value{
An \code{\link[xpose]{xpose_data}} object suitable for use in 'xpose'.
}
\description{
Convert 'nlmixr2' model output into an 'xpose' database.
}
\examples{
\dontrun{
library(nlmixr2)

one.cmt <- function() {
  ini({
    ## You may label each parameter with a comment
    tka <- 0.45 # Ka
    tcl <- log(c(0, 2.7, 100)) # Log Cl
   ## This works with interactive models
    ## You may also label the preceding line with label("label text")
    tv <- 3.45; label("log V")
    ## the label("Label name") works with all models
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd)
  })
}

theo_sd_fit <- nlmixr2(one.cmt, theo_sd, "focei", control=foceiControl(print=0))

xpdb <- xpose_data_nlmixr2(obj = theo_sd_fit)
}

}
