% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/functions_package.R
\name{Zeta.scale.min.dist}
\alias{Zeta.scale.min.dist}
\title{Zeta diversity scaling with sample grain dependency based on minimum distance}
\usage{
Zeta.scale.min.dist(xy, data.spec, n, order = 1, reorder = 100,
  sam = 1000, plot = TRUE, sd = TRUE)
}
\arguments{
\item{xy}{Site-by-coordinate data frame, with sites as rows and coordinates as columns.}

\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{n}{Vector of aggregation indices: regularly spaced sites are grouped as n[i] x n[i] sites.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{reorder}{Number of times the sites are rearranged and grouped together for the computation of zeta.}

\item{sam}{Number of samples for which the zeta-diversity is computed.}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted.}

\item{sd}{Boolean value (TRUE or FALSE) indicating if the standard deviation must be plotted for each grain.}
}
\value{
\code{zeta.scale.min.dist} returns a matrix containing the zeta-diversity values over the '\code{reorder}' computations, for each grain.
}
\description{
Computes zeta diversity scaling with sample grain for a specific order (number of assemblages or sites), increasing grain by sequentially adding sites based on the minimum distance between them.
}
\details{
The nearest neighbouring sites (plots, quadrates, or areas of varying shapes) are grouped as spatial clusters of 2, 3, 4, etc. sites, based on the minimum distance between them. Since the procedure is based on the relative distance between sites, the site order can have an impact on the output. The procedure is therefore performed 'reorder' times, for which sites are randomly reordered each time, and the mean zeta is computed. This function is suitable for both regularly and irregularly spaced sites, contiguous or non contiguous. For regularly spaced sites, the use of \code{\link{Zeta.scale.regular}} is recommended.
}
\examples{
data(Marion.species)
xy <- Marion.species[1:2]
data.species <- Marion.species[3:33]

dev.new()
zeta.scale.irreg.species <- Zeta.scale.min.dist(xy, data.species, n = 1:3, order = 3,
    reorder = 3, sam = 50)
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.

Scheiner S.M., Chiarucci A., Fox G.A., Helmus M.R., McGlinn D.J. & Willig M.R. (2011). The underpinnings of the relationship of species richness with space and time. \emph{Ecological Monographs}, 81, 195-213.
}
\seealso{
\code{\link{Zeta.decline}}, \code{\link{Zeta.order}}, \code{\link{Zeta.scale.regular}}
}

