% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.River}
\alias{Plot.River}
\title{Plot.River}
\usage{
Plot.River(
  dt = NULL,
  AggMethod = "mean",
  PreAgg = TRUE,
  XVar = NULL,
  YVar = NULL,
  GroupVar = NULL,
  YVarTrans = "Identity",
  XVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  Height = NULL,
  Width = NULL,
  Title = "River Plot",
  ShowLabels = FALSE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  EchartsTheme = "macarons",
  MouseScroll = TRUE,
  TimeLine = TRUE,
  ShowSymbol = FALSE,
  TextColor = "white",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = "#63aeff",
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  xaxis.fontSize = 14,
  yaxis.fontSize = 14,
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{AggMethod}{character}

\item{PreAgg}{logical}

\item{XVar}{X-Axis variable name}

\item{YVar}{Y-Axis variable name. You can supply multiple YVars}

\item{GroupVar}{One Grouping Variable}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{XVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{FacetRows}{Defaults to 1 which causes no faceting to occur vertically. Otherwise, supply a numeric value for the number of output grid rows}

\item{FacetCols}{Defaults to 1 which causes no faceting to occur horizontally. Otherwise, supply a numeric value for the number of output grid columns}

\item{FacetLevels}{Faceting rows x columns is the max number of levels allowed in a grid. If your GroupVar has more you can supply the levels to display.}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{"Title"}

\item{ShowLabels}{character}

\item{Title.YAxis}{character}

\item{Title.XAxis}{character}

\item{EchartsTheme}{Provide an "Echarts" theme}

\item{MouseScroll}{logical, zoom via mouse scroll}

\item{TimeLine}{Logical}

\item{ShowSymbol}{= FALSE}

\item{TextColor}{"Not Implemented"}

\item{title.fontSize}{22}

\item{title.fontWeight}{"bold"}

\item{title.textShadowColor}{'#63aeff'}

\item{title.textShadowBlur}{3}

\item{title.textShadowOffsetY}{1}

\item{title.textShadowOffsetX}{-1}

\item{xaxis.fontSize}{14}

\item{yaxis.fontSize}{14}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
This function automatically builds calibration plots and calibration boxplots for model evaluation using regression, stats::quantile regression, and binary and multinomial classification
}
\examples{
# Create fake data
data <- AutoPlots::FakeDataGenerator(N = 1000)

# Build plot
AutoPlots::Plot.River(
  dt = data,
  PreAgg = FALSE,
  AggMethod = "mean",
  XVar = "DateTime",
  YVar = c(
    "Independent_Variable1",
    "Independent_Variable2",
    "Independent_Variable3",
    "Independent_Variable4",
    "Independent_Variable5"),
  YVarTrans = "Identity",
  TextColor = "black",
  EchartsTheme = "macarons")

}
\seealso{
Other Standard Plots: 
\code{\link{ACF}()},
\code{\link{Area}()},
\code{\link{Bar}()},
\code{\link{BarPlot3D}()},
\code{\link{Box}()},
\code{\link{Copula}()},
\code{\link{Copula3D}()},
\code{\link{CorrMatrix}()},
\code{\link{Density}()},
\code{\link{Donut}()},
\code{\link{HeatMap}()},
\code{\link{Histogram}()},
\code{\link{Line}()},
\code{\link{PACF}()},
\code{\link{Parallel}()},
\code{\link{Pie}()},
\code{\link{Plot.ACF}()},
\code{\link{Plot.Area}()},
\code{\link{Plot.Bar}()},
\code{\link{Plot.BarPlot3D}()},
\code{\link{Plot.Box}()},
\code{\link{Plot.Copula}()},
\code{\link{Plot.Copula3D}()},
\code{\link{Plot.CorrMatrix}()},
\code{\link{Plot.Density}()},
\code{\link{Plot.Donut}()},
\code{\link{Plot.HeatMap}()},
\code{\link{Plot.Histogram}()},
\code{\link{Plot.Line}()},
\code{\link{Plot.PACF}()},
\code{\link{Plot.Parallel}()},
\code{\link{Plot.Pie}()},
\code{\link{Plot.ProbabilityPlot}()},
\code{\link{Plot.Radar}()},
\code{\link{Plot.Rosetype}()},
\code{\link{Plot.Scatter}()},
\code{\link{Plot.Scatter3D}()},
\code{\link{Plot.StackedBar}()},
\code{\link{Plot.Step}()},
\code{\link{Plot.WordCloud}()},
\code{\link{ProbabilityPlot}()},
\code{\link{Radar}()},
\code{\link{River}()},
\code{\link{Rosetype}()},
\code{\link{Scatter}()},
\code{\link{Scatter3D}()},
\code{\link{StackedBar}()},
\code{\link{Step}()},
\code{\link{WordCloud}()}
}
\author{
Adrian Antico
}
\concept{Standard Plots}
