% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_usage.R
\name{do_usage}
\alias{do_usage}
\title{Players' usage}
\usage{
do_usage(data_possess, season = "2025-2026")
}
\arguments{
\item{data_possess}{Data frame with the beginning of each possession 
obtained with \code{\link{do_possession}}.}

\item{season}{Season string.}
}
\value{
A data frame with the players' usage.
}
\description{
For each period of a game, this function computes the players' usage, which indicates how 
many possessions each player ended. A possession ends with a field-goal or free-throw attempt, 
or with a turnover.
}
\examples{
\dontrun{
library(dplyr)
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

acb_games_2223_sl <- acb_vbc_cz_sl_2223 \%>\%
  filter(period == "1C")

df1 <- do_prepare_data(df0, day_num, 
                       acb_games_2223_sl, acb_games_2223_info,
                       game_code)
                       
df2 <- do_possession(df1, "1C")    

do_usage(df2, "2022-2023")
}

}
\seealso{
\code{\link{do_possession}}
}
\author{
Guillermo Vinue
}
