% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.BayesMallowsSMC2}
\alias{plot.BayesMallowsSMC2}
\title{Plot Posterior Distributions for BayesMallowsSMC2 Objects}
\usage{
\method{plot}{BayesMallowsSMC2}(x, parameter = "alpha", items = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{BayesMallowsSMC2}, returned from
\code{\link[=compute_sequentially]{compute_sequentially()}}.}

\item{parameter}{Character string defining the parameter to plot. Available
options are \code{"alpha"} (default), \code{"rho"}, and \code{"tau"}.}

\item{items}{The items to study in the plot for \code{rho}. Either a vector of
item names or a vector of indices (1 to n_items). If \code{NULL} and there are
more than 5 items, 5 items are selected randomly. Only used when
\code{parameter = "rho"}.}

\item{...}{Other arguments (currently unused).}
}
\value{
A ggplot object showing:
\itemize{
\item For \code{parameter = "alpha"}: A histogram of the posterior distribution
of the dispersion parameter.
\item For \code{parameter = "tau"}: A histogram of the posterior distribution
of the precision parameter.
\item For \code{parameter = "rho"}: Bar charts showing the posterior probability
of each ranking for each item separately.
}
}
\description{
Visualize posterior distributions of the parameters of the Bayesian Mallows
model after the final timepoint.
}
\details{
The function uses importance weights from the SMC algorithm to compute
weighted posterior distributions. For mixture models (multiple clusters),
separate plots are created for each cluster using faceting.

For \code{parameter = "rho"}, if the number of items is large (> 5) and \code{items}
is not specified, a random subset of 5 items is selected for visualization.
The random selection respects the current random seed, so results are
reproducible if you set a seed before calling the function (e.g., with
\code{set.seed()}).
}
\examples{
\donttest{
# Fit a model with complete rankings
mod <- compute_sequentially(
  complete_rankings,
  hyperparameters = set_hyperparameters(n_items = 5),
  smc_options = set_smc_options(n_particles = 100, n_particle_filters = 1)
)

# Plot alpha (default)
plot(mod)

# Plot tau
plot(mod, parameter = "tau")

# Plot rho for specific items
plot(mod, parameter = "rho", items = c(1, 3, 5))

# Plot rho for all items (if <= 5 items)
plot(mod, parameter = "rho")
}
}
