% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flagAbsent.R
\name{flagAbsent}
\alias{flagAbsent}
\title{Flags occurrences that are marked as absent}
\usage{
flagAbsent(data = NULL, PresAbs = "occurrenceStatus")
}
\arguments{
\item{data}{A data frame or tibble. Occurrence records as input.}

\item{PresAbs}{Character. The column in which the function will find "ABSENT" or "PRESENT" records.
Default = "occurrenceStatus"}
}
\value{
The input data with a new column called ".occurrenceAbsent" where FALSE == "ABSENT" records.
}
\description{
Flags occurrences that are "ABSENT" for the occurrenceStatus (or some other user-specified) column.
}
\examples{
  # Bring in the data
data(beesRaw)
  # Run the function
beesRaw_out <- flagAbsent(data = beesRaw,
PresAbs = "occurrenceStatus")
  # See the result
table(beesRaw_out$.occurrenceAbsent, useNA = "always")
}
