% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_station_timeseries}
\alias{plot_station_timeseries}
\title{Plot Station Time Series with Seasonal Detection}
\usage{
plot_station_timeseries(
  df,
  station,
  var = "Avg.Tn",
  smooth = TRUE,
  theme_dark = FALSE
)
}
\arguments{
\item{df}{A tidy dataset containing columns: \code{Station}, \code{Date}, \code{LAT}, and variables.}

\item{station}{Station name.}

\item{var}{Climate variable to plot.}

\item{smooth}{Add LOESS smoothing line.}

\item{theme_dark}{Use dark theme.}
}
\value{
A ggplot object.
}
\description{
Creates a time-series plot for climate variables with automatic hemisphere-based season detection.
}
\examples{
stations <- create_stations(n = 3)
sim <- simulate_climate_series(stations)
plot_station_timeseries(sim, station = "Station_1", var = "Avg.Tn")

}
