% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_station_csv}
\alias{write_station_csv}
\title{Write station CSV
Exports a simulated climate station dataset to a CSV file.}
\usage{
write_station_csv(df, file = "simulated_station_climate.csv")
}
\arguments{
\item{df}{A dataframe returned by \code{simulate_climate_series()}.}

\item{file}{The output CSV filename.}
}
\value{
Returns the file path invisibly.
}
\description{
Write station CSV
Exports a simulated climate station dataset to a CSV file.
}
\examples{
stations <- create_stations(n = 3)
sim <- simulate_climate_series(stations)
tmp <- tempfile(fileext = ".csv")
write_station_csv(sim, tmp)

}
